<?php
/**
 * LUXOR IPTV Admin Panel - Installation Script
 *
 * Run this once to set up the database
 */

$step = isset($_GET['step']) ? (int)$_GET['step'] : 1;
$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';

    if ($action === 'test_connection') {
        $host = $_POST['db_host'] ?? 'localhost';
        $name = $_POST['db_name'] ?? '';
        $user = $_POST['db_user'] ?? '';
        $pass = $_POST['db_pass'] ?? '';

        try {
            $pdo = new PDO("mysql:host={$host}", $user, $pass);
            $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

            // Create database if not exists
            $pdo->exec("CREATE DATABASE IF NOT EXISTS `{$name}` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
            $pdo->exec("USE `{$name}`");

            // Run schema
            $schema = file_get_contents(__DIR__ . '/schema.sql');
            // Remove CREATE DATABASE and USE statements (we already did that)
            $schema = preg_replace('/CREATE DATABASE.*?;/s', '', $schema);
            $schema = preg_replace('/USE.*?;/s', '', $schema);

            // Split and execute each statement
            $statements = array_filter(array_map('trim', explode(';', $schema)));
            foreach ($statements as $stmt) {
                if (!empty($stmt)) {
                    $pdo->exec($stmt);
                }
            }

            // Update config file
            $configContent = file_get_contents(__DIR__ . '/../includes/config.php');
            $configContent = preg_replace("/define\('DB_HOST', '.*?'\);/", "define('DB_HOST', '{$host}');", $configContent);
            $configContent = preg_replace("/define\('DB_NAME', '.*?'\);/", "define('DB_NAME', '{$name}');", $configContent);
            $configContent = preg_replace("/define\('DB_USER', '.*?'\);/", "define('DB_USER', '{$user}');", $configContent);
            $configContent = preg_replace("/define\('DB_PASS', '.*?'\);/", "define('DB_PASS', '{$pass}');", $configContent);

            // Generate random API key
            $apiKey = bin2hex(random_bytes(16));
            $configContent = preg_replace("/define\('API_SECRET_KEY', '.*?'\);/", "define('API_SECRET_KEY', '{$apiKey}');", $configContent);

            file_put_contents(__DIR__ . '/../includes/config.php', $configContent);

            $success = 'Installation completed successfully!';
            $step = 2;

        } catch (PDOException $e) {
            $error = 'Database error: ' . $e->getMessage();
        }
    }

    if ($action === 'change_admin') {
        require_once __DIR__ . '/../includes/db.php';

        $username = trim($_POST['admin_user'] ?? '');
        $password = $_POST['admin_pass'] ?? '';

        if (strlen($username) < 3) {
            $error = 'Username must be at least 3 characters';
        } elseif (strlen($password) < 6) {
            $error = 'Password must be at least 6 characters';
        } else {
            $hashedPassword = password_hash($password, PASSWORD_DEFAULT);
            db()->query("UPDATE admins SET username = :user, password = :pass WHERE id = 1", [
                'user' => $username,
                'pass' => $hashedPassword
            ]);
            $success = 'Admin credentials updated! Redirecting to login...';
            $step = 3;
        }
    }
}
?>
<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation - LUXOR IPTV Admin</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #1a1c1e 0%, #2d2d3a 100%);
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            color: #fff;
        }
        .setup-card {
            background: rgba(255,255,255,0.05);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255,255,255,0.1);
            border-radius: 16px;
            padding: 40px;
            width: 100%;
            max-width: 500px;
        }
        .form-control {
            background: rgba(255,255,255,0.1);
            border: 1px solid rgba(255,255,255,0.2);
            color: #fff;
        }
        .form-control:focus {
            background: rgba(255,255,255,0.15);
            border-color: #6200EE;
            color: #fff;
            box-shadow: 0 0 0 0.2rem rgba(98, 0, 238, 0.25);
        }
        .btn-primary {
            background: #6200EE;
            border: none;
        }
        .step-indicator {
            display: flex;
            justify-content: center;
            margin-bottom: 30px;
        }
        .step {
            width: 30px;
            height: 30px;
            border-radius: 50%;
            background: rgba(255,255,255,0.2);
            display: flex;
            align-items: center;
            justify-content: center;
            margin: 0 10px;
            font-size: 14px;
        }
        .step.active {
            background: #6200EE;
        }
        .step.completed {
            background: #4caf50;
        }
    </style>
</head>
<body>
    <div class="setup-card">
        <div class="text-center mb-4">
            <div style="font-size: 48px;">📺</div>
            <h2>LUXOR IPTV Admin</h2>
            <p class="text-muted">Installation Wizard</p>
        </div>

        <div class="step-indicator">
            <div class="step <?php echo $step >= 1 ? ($step > 1 ? 'completed' : 'active') : ''; ?>">1</div>
            <div class="step <?php echo $step >= 2 ? ($step > 2 ? 'completed' : 'active') : ''; ?>">2</div>
            <div class="step <?php echo $step >= 3 ? 'active' : ''; ?>">3</div>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-danger"><?php echo htmlspecialchars($error); ?></div>
        <?php endif; ?>

        <?php if ($success): ?>
            <div class="alert alert-success"><?php echo htmlspecialchars($success); ?></div>
        <?php endif; ?>

        <?php if ($step === 1): ?>
            <h4 class="mb-3">Step 1: Database Configuration</h4>
            <form method="POST">
                <input type="hidden" name="action" value="test_connection">

                <div class="mb-3">
                    <label class="form-label">Database Host</label>
                    <input type="text" class="form-control" name="db_host" value="localhost" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Database Name</label>
                    <input type="text" class="form-control" name="db_name" value="luxor_admin" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Database User</label>
                    <input type="text" class="form-control" name="db_user" value="root" required>
                </div>

                <div class="mb-3">
                    <label class="form-label">Database Password</label>
                    <input type="password" class="form-control" name="db_pass">
                </div>

                <button type="submit" class="btn btn-primary w-100">Install Database</button>
            </form>

        <?php elseif ($step === 2): ?>
            <h4 class="mb-3">Step 2: Admin Account</h4>
            <p class="text-muted mb-3">Change the default admin credentials:</p>
            <form method="POST">
                <input type="hidden" name="action" value="change_admin">

                <div class="mb-3">
                    <label class="form-label">Admin Username</label>
                    <input type="text" class="form-control" name="admin_user" value="admin" required minlength="3">
                </div>

                <div class="mb-3">
                    <label class="form-label">Admin Password</label>
                    <input type="password" class="form-control" name="admin_pass" required minlength="6">
                    <small class="text-muted">Minimum 6 characters</small>
                </div>

                <button type="submit" class="btn btn-primary w-100">Set Admin Credentials</button>
            </form>

        <?php elseif ($step === 3): ?>
            <h4 class="mb-3">Installation Complete! 🎉</h4>
            <p class="text-muted">Your admin panel is ready to use.</p>

            <div class="alert alert-warning">
                <strong>Important:</strong> Delete this <code>install</code> folder for security!
            </div>

            <a href="../index.php" class="btn btn-primary w-100">Go to Login</a>
        <?php endif; ?>
    </div>

    <?php if ($step === 3): ?>
    <script>
        setTimeout(function() {
            window.location.href = '../index.php';
        }, 3000);
    </script>
    <?php endif; ?>
</body>
</html>
