-- LUXOR IPTV Admin Panel Database Schema
-- Run this SQL to create the database structure

CREATE DATABASE IF NOT EXISTS luxor_admin CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci;
USE luxor_admin;

-- Admin users table
CREATE TABLE IF NOT EXISTS `admins` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `username` VARCHAR(50) NOT NULL UNIQUE,
    `password` VARCHAR(255) NOT NULL,
    `email` VARCHAR(100),
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `last_login` TIMESTAMP NULL,
    `is_active` TINYINT(1) DEFAULT 1
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Xtream server configurations (1-5 URLs with fallback)
CREATE TABLE IF NOT EXISTS `xtream_servers` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `priority` INT NOT NULL DEFAULT 1,  -- 1 = primary, 2-5 = fallbacks
    `name` VARCHAR(100) NOT NULL,
    `host` VARCHAR(255) NOT NULL,
    `port` VARCHAR(10) DEFAULT '80',
    `protocol` ENUM('http', 'https') DEFAULT 'http',
    `is_active` TINYINT(1) DEFAULT 1,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    UNIQUE KEY `unique_priority` (`priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- App branding/customization
CREATE TABLE IF NOT EXISTS `app_settings` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `setting_key` VARCHAR(50) NOT NULL UNIQUE,
    `setting_value` TEXT,
    `updated_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Connection logs (optional - for statistics)
CREATE TABLE IF NOT EXISTS `connection_logs` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `device_id` VARCHAR(100),
    `server_used` INT,
    `username` VARCHAR(100),
    `ip_address` VARCHAR(45),
    `user_agent` TEXT,
    `status` ENUM('success', 'failed') DEFAULT 'success',
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`server_used`) REFERENCES `xtream_servers`(`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default admin (username: admin, password: admin123)
-- IMPORTANT: Change this password after first login!
INSERT INTO `admins` (`username`, `password`, `email`) VALUES
('admin', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin@example.com');

-- Insert default app settings
INSERT INTO `app_settings` (`setting_key`, `setting_value`) VALUES
('app_name', 'LUXOR IPTV'),
('app_logo_url', ''),
('primary_color', '#6200EE'),
('require_login', '1'),
('max_devices_per_user', '3'),
('panel_version', '1.0.0');

-- Insert example server (remove or modify)
INSERT INTO `xtream_servers` (`priority`, `name`, `host`, `port`, `protocol`, `is_active`) VALUES
(1, 'Primary Server', 'example.com', '80', 'http', 0);
